package com.clx.performance.controller.app.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.AppCarrierDriverCollectSaveParam;
import com.clx.performance.param.app.collect.AppCarrierDriverCollectTransportIntentionParam;
import com.clx.performance.service.collect.CollectDriverTransportIntentionService;
import com.clx.performance.service.collect.DriverTransportIntentionInfoService;
import com.clx.performance.vo.pc.collect.CarrierDriverCollectTransportIntentionVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping(value="/app/collect/intention")
@Validated
@Tag(name = "承运司机端-拉运意愿")
@AllArgsConstructor
public class AppCarrierDriverCollectTransportIntentionController {

    private final DriverTransportIntentionInfoService driverTransportIntentionInfoService;
    private final CollectDriverTransportIntentionService collectDriverTransportIntentionService;

    @Operation(summary = "获取Web端已配置的拉运意愿列表",description = "<br>By:马路路")
    @PostMapping("/getList")
    Result<PageData<CarrierDriverCollectTransportIntentionVO>> getList(@RequestBody AppCarrierDriverCollectTransportIntentionParam param) {
        IPage<CarrierDriverCollectTransportIntentionVO> page = collectDriverTransportIntentionService.listCarrierDriverCollectTransportIntentionAll(param);
        return Result.page(page.getRecords(),  page.getTotal(), page.getPages());
    }

    @Operation(summary = "保存已勾选拉运意愿",description = "<br>By:马路路")
    @PostMapping("/saveCheckedList")
    public Result<Object> saveCheckedList(@RequestBody AppCarrierDriverCollectSaveParam param) {
        driverTransportIntentionInfoService.saveCheckedList(param);
        return Result.ok();
    }

    @Operation(summary = "获取当前用户已勾选信息", description = "<br>By:马路路")
    @PostMapping("/getCurrentUserCheckInfo")
    public Result<List<CarrierDriverCollectTransportIntentionVO>> getCurrentUserCheckInfo() {
        return Result.ok(driverTransportIntentionInfoService.getCurrentUserCheckInfo());
    }
}
