package com.clx.performance.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.OrderGoodsCancelParam;
import com.clx.performance.param.pc.UpdateEditOrderGoodsParam;
import com.clx.performance.param.pc.PageOrderGoodsListParam;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.param.pc.UpdateOrderGoodsPriceParam;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.clx.performance.vo.pc.OrderGoodsEditVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsService {
    OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo);

    OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo);

    IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param);

    void updateOrderGoodsReduceWeightAndStatus(Integer id, BigDecimal orderChildWeight, Integer orderGoodsStatus);
    void updateOrderGoodsReduceWeightAndStatus(OrderGoods orderGoods, BigDecimal orderChildWeight, Integer orderGoodsStatus);

    IPage<OrderGoodsAPPVO> indexOrderGoodsList(OrderGoodsListPageParam orderGoodsListParam);

    List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(String orderNo);

    List<OrderGoods> getOrderGoodsList(String orderNo, LocalDateTime lastArriveSendTime);

    /**
     * 获取订单取消的时候订单样式
     * @param orderNo
     * @return
     */
    String orderCancelStyle(String orderNo);

    /**
     * 获取当前订单可取消吨数
     * @param orderNo
     * @param optionType
     * @return
     */
    BigDecimal orderCancelResidueWeight(String orderNo,String optionType);

    void updateEditOrderGoods(UpdateEditOrderGoodsParam param);

    void updateOrderGoodsPrice(UpdateOrderGoodsPriceParam param);

    Boolean updateOrderGoodsStopFlag(String orderNo,Integer stopFlag);

    /**
     * 获取货单取消的时候弹窗样式
     * @param orderGoodsNo
     * @return
     */
    String orderGoodsCancelStyle(String orderGoodsNo);

    /**
     * 取消货单
     * @param orderGoodsNo
     */
    void orderGoodsCancel(OrderGoodsCancelParam orderGoodsNo);

    /**
     * 查看货单可取消吨数
     * @param goodsCancelParam
     * @return
     */
    BigDecimal orderGoodsCancelResidueWeight(OrderGoodsCancelParam goodsCancelParam);

    List<String> getOrderChildTruckList(String orderGoodsNo);

    /**
     * 编辑货单查询
     * @param id
     * @return
     */
    OrderGoodsEditVO findOrderGoodsById(Integer id);

    Boolean updateSystemAddressId( Integer ownerAddressId, Integer systemAddressId);
}
