package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;

import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRuleAddParam;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRuleStatusUpdateParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRuleParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRuleService;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleFileVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRulePullDownVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract/ownerRule")
@Validated
@Api(tags = "承运端-货主违约规则")
@AllArgsConstructor
public class CarrierBreakContractOwnerRuleController {

    private final BreakContractOwnerRuleService breakContractOwnerRuleService;

    @ApiOperation(value = "新增货主违约规则", notes = "<br>By:艾庆国")
    @PostMapping("/saveRule")
    @UnitCovert
    public Result<Void> saveRule(@RequestBody @Validated BreakContractOwnerRuleAddParam param) {
        if (StringUtils.isBlank(param.getRule().get("A-a"))){throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER);};
        if (StringUtils.isBlank(param.getRule().get("A-b"))){throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER);};
        if (StringUtils.isBlank(param.getRule().get("A-c"))){throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER);};
        if (StringUtils.isBlank(param.getRule().get("A-d"))){throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER);};

        breakContractOwnerRuleService.saveRule(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新状态", notes = "<br>By:艾庆国")
    @PostMapping("/updateStatus")
    public Result<Void> updateStatus(@RequestBody @Validated BreakContractOwnerRuleStatusUpdateParam param) {
        breakContractOwnerRuleService.updateStatus(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询规则详情", notes = "<br>By:艾庆国")
    @GetMapping("/getRuleInfo")
    @UnitCovert(param = false)
    public Result<BreakContractOwnerRuleVO> getRuleInfo(Integer id) {

        return Result.ok(breakContractOwnerRuleService.getRuleInfo(id));
    }

    @ApiOperation(value = "查询规则文档信息", notes = "<br>By:艾庆国")
    @GetMapping("/getRuleFile")
    public Result<BreakContractOwnerRuleFileVO> getRuleFile(Integer id) {

        return Result.ok(breakContractOwnerRuleService.getRuleFile(id));
    }

    @ApiOperation(value = "分页搜索违约列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageRule")
    @UnitCovert(param = false)
    public Result<PageData<BreakContractOwnerRuleVO>> pageRule(@RequestBody @Validated PageBreakContractOwnerRuleParam param) {
        IPage<BreakContractOwnerRuleVO> page = breakContractOwnerRuleService.pageRule(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "查询方案下拉列表",notes = "<br>By:艾庆国")
    @PostMapping("/listPullDown")
    public Result<List<BreakContractOwnerRulePullDownVO>> listPullDown() {
        return Result.ok(breakContractOwnerRuleService.listPullDown());
    }

}
