package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.param.pc.PageMonitorOrderChildQCParam;
import com.clx.performance.param.pc.OrderChildCarrierCancelParam;
import com.clx.performance.param.pc.PageCarrierOrderChildParam;
import com.clx.performance.service.OrderChildPoundAuditService;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.vo.pc.*;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/orderChild")
@Validated
@Api(tags = "承运端-运单列表")
@AllArgsConstructor
public class CarrierOrderChildController {

    private final OrderChildService orderChildService;

    @ApiOperation(value = "运单列表",notes = "<br>By:李瑞新")
    @PostMapping("/pageCarrierOrderChildList")
    @UnitCovert(param = false)
    public Result<PageData<PageCarrierOrderChildVO>> pageCarrierOrderChildList(@RequestBody PageCarrierOrderChildParam param) {
        IPage<PageCarrierOrderChildVO> page = orderChildService.pageCarrierOrderChildList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @ApiOperation(value = "运单详情详情",notes = "<br>By:李瑞新")
    @GetMapping("/getCarrierOrderChildDetail")
    @UnitCovert(param = false)
    public Result<CarrierOrderChildDetailVO> getCarrierOrderChildDetail(@NotBlank(message = "运单编号不能为空") String childNo) {
        return Result.ok(orderChildService.getCarrierOrderChildDetail(childNo));
    }


    @ApiOperation(value = "运单状态列表",notes = "<br>By:李瑞新")
    @GetMapping("/getOrderChildStatusList")
    public Result<List<OrderChildStatusVO>> getOrderChildStatusList() {
        ConcurrentHashMap<Integer, String> map = OrderChildEnum.map;
        List<OrderChildStatusVO> result = map.entrySet().stream().map(c -> new OrderChildStatusVO(c.getKey(), c.getValue())).collect(Collectors.toList());
        Collections.sort(result, new Comparator<OrderChildStatusVO>() {
            @Override
            public int compare(OrderChildStatusVO o1, OrderChildStatusVO o2) {
                Integer status1= o1.getStatus();
                Integer status2= o2.getStatus();
                return  status1.compareTo(status2);
            }
        });
        return Result.ok(result);
    }

    @ApiOperation(value = "取消运单", notes = "<br>By:艾庆国")
    @PostMapping("/updateCancel")
    public Result<Void> updateCarrierCancel(@RequestBody @Validated OrderChildCarrierCancelParam param) {
        orderChildService.updateCarrierCancel(param);

        return Result.ok();
    }

    @ApiOperation(value = "业务信息", notes = "<br>By:胡宇帆")
    @GetMapping("/orderChildBussInfo")
    public Result<OrderChildBussInfoVO> getOrderChildBussInfo(@NotBlank(message = "车牌号不能为空") String truckNo) {
        return Result.ok(orderChildService.getOrderChildBussInfo(truckNo));
    }


    @ApiOperation(value = "全量运单监控预警列表", notes = "<br>By:刘海泉")
    @RequestMapping(value = "/getMonitorOrerChildListsByParam", method = RequestMethod.POST)
    public Result<PageData<OutputMonitorOrderChildVO>> getMonitorOrerChildListsByParam(@RequestBody @Validated PageMonitorOrderChildQCParam param) {
        IPage<OutputMonitorOrderChildVO> page = orderChildService.getMonitorOrerChildListsByParam(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    //模拟
    @GetMapping("/orderChildExpect")
    public void getMonitorOrerChildListsByParam() {
        orderChildService.orderChildExpect();
    }


}
