package com.clx.performance.controller.feign;

import cn.hutool.core.collection.CollectionUtil;
import com.clx.performance.model.OrderChild;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.service.child.FeignOrderChildService;
import com.clx.performance.vo.pc.child.OrderChildLineStatisticsVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

@RestController
@RequestMapping("/feign/orderChild")
@Validated
@Api(tags = "运单Feign")
@AllArgsConstructor
public class OrderChildFeignController {

    private final OrderChildService orderChildService;

    private final FeignOrderChildService feignOrderChildService;


    @GetMapping({"/getOrderChildTotalByUserNo"})
    Integer getTrucksByOrderGoodsNo(@RequestParam("userNo") @NotNull(message = "用户编号不可为空") Long userNo) {
        Integer totalByUserNo = orderChildService.getOrderChildTotalByUserNo(userNo);
        return totalByUserNo;
    }

    /**
     * 查询在途运单
     *
     * @param orderNo
     * @return
     */
    @GetMapping({"/selectInTransitOrderChild"})
    Result<Boolean> selectInTransitOrderChild(@RequestParam("orderNo") String orderNo) {
        List<OrderChild> orderChildren = orderChildService.selectInTransitOrderChild(orderNo);
        if (CollectionUtil.isNotEmpty(orderChildren)) {
            return Result.ok(true);
        } else {
            return Result.ok(false);
        }
    }

    @ApiOperation(value = "线路运单统计", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/lineStatistics", method = RequestMethod.GET)
    Result<OrderChildLineStatisticsVO> lineStatistics(@RequestParam @NotNull(message = "发货地址不可为空") Integer sendSystemAddressId,
                                                      @RequestParam @NotNull(message = "收货货地址不可为空") Integer receiveSystemAddressId){

        return Result.ok(feignOrderChildService.getLineStatistics(sendSystemAddressId, receiveSystemAddressId));

    }

}
