package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

@Getter
@AllArgsConstructor
public enum UserTypeEnum {

        OWNER(1, "货主"),
        CARRIER(2, "承运端"),
        DRIVER(3, "司机");

        private final Integer code;
        private final String msg;

        public static Optional<UserTypeEnum> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

}
