package com.clx.performance.service.impl.breakcontract;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyBreakContractConstants;
import com.clx.performance.param.mq.BreakContractOwnerRuleAddMqParam;
import com.clx.performance.service.breakcontract.BreakContractMqService;
import com.clx.performance.service.impl.IntegralMqHandlerServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author: aiqingguo
 * @Description: 司机积分 mq
 * @Date: 2023-10-10 13:21:07
 * @Version: 1.0
 */

@Slf4j
@Service
public class BreakContractMqServiceImpl implements BreakContractMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private IntegralMqHandlerServiceImpl integralMqHandlerService;


    @Override
    public void ownerRuleAdd(Integer ruleId) {
        BreakContractOwnerRuleAddMqParam mq = new BreakContractOwnerRuleAddMqParam();
        mq.setRuleId(ruleId);

        MqDelay<MqWrapper<BreakContractOwnerRuleAddMqParam>> delay = new MqDelay<>(RabbitKeyBreakContractConstants.DEFAULT_EXCHANGE, RabbitKeyBreakContractConstants.OWNER_RULE_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyBreakContractConstants.DEFAULT_EXCHANGE, RabbitKeyBreakContractConstants.DEFAULT_DELAY_ROUTING_KEY, message);

    }
}
