package com.clx.performance.listener;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.service.OrderCancelService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
public class OrderCancelHandler {

    @Autowired
    private OrderCancelService orderCancelService;

    @RabbitListener(queues = RabbitKeyConstants.ORDER_CANCEL_QUEUE)
    public void onMessage(String message) {
        log.info("处理订单取消监听器执行,订单No为{}", message);
        OrderCancelParam param = JSONUtil.toBean(message, OrderCancelParam.class);
        if (ObjectUtil.equals(param.getCancelType(), 1)) {
            orderCancelService.ownerCancelOrderPrePCMQ(param);
        } else {
            orderCancelService.ownerCancelOrderPrePCMQ(param);
        }

    }
}
