package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.clx.performance.dao.OrderGoodsTruckBindDao;
import com.clx.performance.enums.OrderGoodsTruckBindEnum;
import com.clx.performance.mapper.OrderGoodsTruckBindMapper;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.msl.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * @Author: huyufan
 * @Description: 货单定向绑定车辆表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderGoodsTruckBindDaoImpl extends BaseDaoImpl<OrderGoodsTruckBindMapper, OrderGoodsTruckBind, Integer> implements OrderGoodsTruckBindDao {


    @Override
    public void saveBatchEntity(String orderNo, String orderGoodsNo, List<String> trackList, LocalDateTime now) {
        baseMapper.saveBatchEntity(orderNo, orderGoodsNo, trackList, DateUtils.formatDateTime(now).get());
    }

    @Override
    public boolean updateStatus(OrderGoodsTruckBind item) {
        return update(lUdWrapper()
                .eq(OrderGoodsTruckBind::getId, item.getId())
                .set(OrderGoodsTruckBind::getStatus, item.getStatus())
        );
    }

    @Override
    public List<Integer> getTrucksByOrderGoodsNo(String orderGoodsNo) {
        return baseMapper.getTrucksByOrderGoodsNo(orderGoodsNo);
    }

    @Override
    public Optional<OrderGoodsTruckBind> getByOrderGoodsNoAndTruckNo(String orderGoodsNo, String truckNo) {
        return Optional.ofNullable(getOne(lQrWrapper()
                        .eq(OrderGoodsTruckBind::getOrderGoodsNo, orderGoodsNo)
                        .eq(OrderGoodsTruckBind::getTruckNo, truckNo)
                ));

    }

    @Override
    public Optional<OrderGoodsTruckBind> getValidByOrderGoodsNoAndTruckNo(String truckNo) {
        return Optional.ofNullable(getOne(lQrWrapper()
                .eq(OrderGoodsTruckBind::getTruckNo, truckNo)
                .in(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBind.Status.NORMAL.getCode())
        ));
    }

    @Override
    public Optional<List<OrderGoodsTruckBind>> getValidByTruckNo(String truckNo) {
        return Optional.ofNullable(list(lQrWrapper()
                .eq(OrderGoodsTruckBind::getTruckNo, truckNo)
                .in(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBind.Status.NORMAL.getCode())
        ));
    }


    @Override
    public Optional<List<OrderGoodsTruckBind>> selectListByTruckNo(List<String> truckList) {
        return Optional.ofNullable(baseMapper.selectList(new QueryWrapper<OrderGoodsTruckBind>().lambda()
                        .eq(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBindEnum.Status.SUCCESS.getCode())
                .in(OrderGoodsTruckBind::getTruckNo,truckList).select(OrderGoodsTruckBind::getOrderGoodsNo)));
    }

    @Override
    public void updateOrderGoodsBindStatus(String orderGoodsNo, Integer code) {
        update(lUdWrapper()
                .eq(OrderGoodsTruckBind::getOrderGoodsNo, orderGoodsNo)
                .set(OrderGoodsTruckBind::getStatus, code)
        );
    }

    @Override
    public void updateOrderGoodsBindStatus(String orderGoodsNo, Integer code, List<String> truckList) {
        update(lUdWrapper()
                .set(OrderGoodsTruckBind::getStatus, code)
                .eq(OrderGoodsTruckBind::getOrderGoodsNo, orderGoodsNo)
                .in(OrderGoodsTruckBind::getTruckNo, truckList)
                .or()
                .eq(OrderGoodsTruckBind::getOrderGoodsNo, orderGoodsNo)
                .eq(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBindEnum.Status.SUCCESS.getCode())
        );
    }

    @Override
    public List<OrderGoodsTruckBind> selectListByOrderGoodsNo(String orderGoodsNo) {
        return baseMapper.selectList(lQrWrapper().eq(OrderGoodsTruckBind::getOrderGoodsNo, orderGoodsNo)
                .eq(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBindEnum.Status.SUCCESS.getCode())
                .or()
                .eq(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBindEnum.Status.GET.getCode())
        );
    }

    @Override
    public void updateOrderGoodsBindStatusExpire(String orderGoodsNo) {
        update(lUdWrapper()
                .eq(OrderGoodsTruckBind::getOrderGoodsNo, orderGoodsNo)
                .eq(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBindEnum.Status.SUCCESS.getCode())
                .set(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBindEnum.Status.EXPIRE.getCode())
        );
    }

    @Override
    public List<OrderGoodsTruckBind> getTrucksBindByOrderGoodsNo(String orderGoodsNo,String truckNo) {
        LambdaQueryWrapper<OrderGoodsTruckBind> query = new LambdaQueryWrapper<>();

        query.eq(OrderGoodsTruckBind::getOrderGoodsNo, orderGoodsNo);
        if(StringUtils.isNotBlank(truckNo)){
            query.eq(OrderGoodsTruckBind::getTruckNo, truckNo);
        }
        query.in(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBindEnum.Status.SUCCESS.getCode(),OrderGoodsTruckBindEnum.Status.GET.getCode());
        query.orderByDesc(OrderGoodsTruckBind :: getCreateTime);
        return baseMapper.selectList(query);
    }

    @Override
    public List<OrderGoodsTruckBind> judgeTruckIsBindDxOrder(Set<String> set) {
        LambdaQueryWrapper<OrderGoodsTruckBind> query = new LambdaQueryWrapper<>();
        query.in(OrderGoodsTruckBind::getTruckNo, set);
        query.in(OrderGoodsTruckBind :: getStatus,OrderGoodsTruckBindEnum.Status.SUCCESS.getCode(),OrderGoodsTruckBindEnum.Status.GET.getCode());
        return baseMapper.selectList(query);
    }

    @Override
    public void deleteByIds(List<Integer> ids) {
        baseMapper.deleteBatchIds(ids);
    }
}
