package com.clx.performance.constant;

/**
 * @Author: aiqingguo
 * @Description: 违约-mq
 * @Date: 2023-10-12 15:27:23
 * @Version: 1.0
 */
public class RabbitKeyBreakContractConstants {

    private static final String PREFIX = "clx-performance.breakContract.";
    private static final String EXCHANGE = ".exchange";
    private static final String QUEUE = ".queue";
    private static final String QUEUE_ROUTING_KEY = ".routing.key";
    private static final String DELAY_QUEUE = ".delay.queue";
    private static final String DELAY_ROUTING_KEY = ".delay.routing.key";
    private static final String DEAD_QUEUE = ".dead.queue";
    private static final String DEAD_ROUTING_KEY = ".dead.routing.key";

    private RabbitKeyBreakContractConstants() {
    }

    /**
     * 缺省交换机
     */
    public static final String DEFAULT_EXCHANGE = PREFIX +"default"+EXCHANGE;

    /**
     * 缺省延迟队列
     */
    public static final String DEFAULT_DELAY_QUEUE = PREFIX +"default"+DELAY_QUEUE;
    public static final String DEFAULT_DELAY_ROUTING_KEY = PREFIX +"default"+DELAY_ROUTING_KEY;
    public static final String DEFAULT_DEAD_QUEUE = PREFIX +"default"+DEAD_QUEUE;
    public static final String DEFAULT_DEAD_ROUTING_KEY = PREFIX +"default"+DEAD_ROUTING_KEY;

    /**
     * 新增货主违约规则
     */
    public static final String OWNER_RULE_ADD_QUEUE = PREFIX +"ownerRule.add"+QUEUE;
    public static final String OWNER_RULE_ADD_ROUTING_KEY = PREFIX +"ownerRule.add"+QUEUE_ROUTING_KEY;

}
