package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyBreakContractConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 违约 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitBreakContractConfig {

    @Bean
    public DirectExchange breakContractDefaultExchange() {
        return new DirectExchange(RabbitKeyBreakContractConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue breakContractDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeyBreakContractConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeyBreakContractConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeyBreakContractConstants.DEFAULT_DELAY_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding breakContractDefaultDelayQueueBinding() {
        return BindingBuilder.bind(breakContractDefaultDelayQueue()).to(breakContractDefaultExchange()).with(RabbitKeyBreakContractConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue breakContractDefaultDeadQueue() {
        return new Queue(RabbitKeyBreakContractConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding breakContractDefaultDeadQueueBinding() {
        return BindingBuilder.bind(breakContractDefaultDeadQueue()).to(breakContractDefaultExchange()).with(RabbitKeyBreakContractConstants.DEFAULT_DEAD_ROUTING_KEY);
    }


    /**
     * 货主规则新增
     */
    @Bean
    public Queue breakContractOwnerRuleAddQueue() {
        return new Queue(RabbitKeyBreakContractConstants.OWNER_RULE_ADD_QUEUE);
    }
    @Bean
    public Binding breakContractOwnerRuleAddQueueBinding() {
        return BindingBuilder.bind(breakContractOwnerRuleAddQueue()).to(breakContractDefaultExchange()).with(RabbitKeyBreakContractConstants.OWNER_RULE_ADD_ROUTING_KEY);
    }

}
