package com.clx.performance.config;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Profile({"dev", "test", "release"})
@Configuration
public class Knife4jConfig {
    @Value("${spring.application.name}")
    private String appName;

    @Bean
    public OpenAPI customOpenApi() {
        return new OpenAPI()
                .info(new Info()
                        .title("诚联信履约服务说明文档")
                        .version("1.0")
                        .description("<div style='font-size=14px;color:red'>诚联信履约服务接口说明</div>")
                        .termsOfService("http://api.clx.cn")
                        .license(new License().name("Apache 2.0")
                                .url("http://doc.xiaominfo.com")));
    }

    @Bean
    public OperationCustomizer customizeGlobalHeaders() {
        return (operation, handlerMethod) -> {
            Parameter token = new Parameter()
                    .name("token")
                    .in(ParameterIn.HEADER.toString())
                    .description("用户登录凭证(token)")
                    .required(true)
                    .schema(new StringSchema());
            Parameter productCode = new Parameter()
                    .name("product-code")
                    .in(ParameterIn.HEADER.toString())
                    .description("产品code")
                    .required(true)
                    .schema(new StringSchema());
            operation.addParametersItem(token)
                    .addParametersItem(productCode);
            return operation;
        };
    }
}
