package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.*;

import java.time.LocalDateTime;

/**
* @Author: jiangwenye
* @Description: 平台账户配置
* @Date: 2024/01/25 17:46:48
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
@Builder
@AllArgsConstructor
public class PlatformAccountConfig implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                   //id

    private Integer businessType;         //应用场景 1-结算单，2-违约结算单，3-充值，4-提现
    private Integer ownerType;            //货主类型 1-企业，2-个人
    private Integer invoiceType;          //开票标识：1网运单 2普通单
    private Integer invoiceCompanyId;     //开票公司id
    private String invoiceCompanyName;    //开票公司名称
    private Integer configRange;          //配置范围：1收款账户 2付款账户
    private String companyName;           //公司名称
    private String bankName;              //银行名称
    private String openBank;              //开户行
    private String bankCode;              //银行编码
    private String bankCardNo;            //银行账号

    private Long createUserNo;            //创建人编码
    private String createUserName;        //创建人姓名
    private Long modifiedUserNo;          //修改人编码
    private String modifiedUserName;      //修改人姓名

    private Integer deleteStatus;         //删除状态: 0-否;1-是
    private LocalDateTime createTime;     //创建时间
    private LocalDateTime modifiedTime;   //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}
