package com.clx.performance.mapper.loan;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.loan.OwnerLoanAccount;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountParam;
import com.clx.performance.sqlProvider.borrower.OwnerLoanAccountSqlProvider;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
public interface OwnerLoanAccountMapper extends BaseMapper<OwnerLoanAccount> {

    @Update("update owner_loan_account set funding_amount = funding_amount + #{account.fundingAmount}"
            + ",virtually_amount = virtually_amount + #{account.virtuallyAmount}"
            + ",modified_time= #{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer addAccount(@Param("account") OwnerLoanAccount account, @Param("now") String nowStr);

//    @Update("update owner_account set funding_amount = funding_amount - #{account.fundingAmount}," +
//            "frozen_balance = frozen_balance + #{account.frozenBalance},account_balance = account_balance - #{account.accountBalance}," +
//            "modified_time=#{now}"
//            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
//    )
//    Integer subAccount(@Param("account") OwnerAccount account, @Param("now") String now);

    /**
     * @see OwnerLoanAccountSqlProvider#pageByParam(Page, PageOwnerLoanAccountParam)
     */
    @SelectProvider(type = OwnerLoanAccountSqlProvider.class, method = "pageByParam")
    IPage<OwnerLoanAccountVO> pageByParam(@Param("page") Page<OwnerLoanAccountVO> page, @Param("param") PageOwnerLoanAccountParam param);

}
