package com.clx.performance.mapper.loan;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.loan.Borrower;
import com.clx.performance.param.pc.loan.carrier.PageBorrowerParam;
import com.clx.performance.sqlProvider.borrower.BorrowerSqlProvider;
import com.clx.performance.vo.pc.loan.carrier.BorrowerVO;
import com.clx.performance.vo.pc.loan.owner.BorrowerSelectVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
* @Author: aiqinguo
* @Description: 借出方
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@Mapper
public interface BorrowerMapper extends BaseMapper<Borrower> {

    /**
     * @see BorrowerSqlProvider#pageByParam(Page, PageBorrowerParam)
     */
    @SelectProvider(type = BorrowerSqlProvider.class, method = "pageByParam")
    IPage<BorrowerVO> pageByParam(@Param("page") Page<BorrowerVO> page, @Param("param") PageBorrowerParam param);


    @SelectProvider(type = BorrowerSqlProvider.class, method = "selectAllBorrowConfig")
    List<BorrowerSelectVO> selectAllBorrowConfig();
}