package com.clx.performance.dao.impl.breakcontract;


import com.clx.performance.dao.breakcontract.BreakContractSettlementLogDao;
import com.clx.performance.mapper.breakcontract.BreakContractSettlementLogMapper;
import com.clx.performance.model.breakcontract.BreakContractSettlementLog;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractSettlementLogDaoImpl extends BaseDaoImpl<BreakContractSettlementLogMapper, BreakContractSettlementLog, Integer> implements BreakContractSettlementLogDao {

    @Override
    public List<BreakContractSettlementLog> getSettlementLogs(String settlementNo) {
        return super.list(lQrWrapper()
                .eq(BreakContractSettlementLog::getSettlementNo, settlementNo)
                .orderByDesc(BreakContractSettlementLog::getId));
    }
}
