package com.clx.performance.controller.thirdparty;

import com.alibaba.fastjson.JSON;
import com.clx.performance.service.thirdparty.nbbank.NbBankNotifyService;
import com.nbopen.api.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping(value="/nbbank")
@Api(tags = "宁波银行回调 (易付通)")
public class NbBankController {

    @Autowired
    private NbBankNotifyService nbBankNotifyService;

    @ApiOperation(value = "notify", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/notify", method = RequestMethod.POST)
    public Object notify(@RequestBody Map<String, Object> body) throws Exception {

        try {

            nbBankNotifyService.payNotify(JSON.toJSONString(body));
            return getResultSuc();
        }catch (Exception e){
            e.printStackTrace();
            return getResultFail();
        }
    }

    private Object getResultSuc() throws Exception {

        Map<String, String> data = new HashMap<>();
        data.put("errorCode", "000000");
        data.put("errorMsg", "成功");

        RequestApiData requestApiData = new RequestApiData();
        requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
        requestApiData.setData(data);
        requestApiData.setServiceId("notifyMerchant");

        RequestHead requestHead = new RequestHead();
        requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

        SDKRequest request = new SDKRequest();
        request.setData(requestApiData);
        request.setHead(requestHead);

        log.info("加密前: "+ JSON.toJSONString(request));
        SDKResponse result = NBOpenSDK.encryptMessage(request);
        log.info("加密后: "+JSON.toJSONString(result));

        return result.getData();
    }

    private Object getResultFail() throws Exception {

        Map<String, String> data = new HashMap<>();
        data.put("errorCode", "ER001");
        data.put("errorMsg", "失败");

        RequestApiData requestApiData = new RequestApiData();
        requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
        requestApiData.setData(data);
        requestApiData.setServiceId("notifyMerchant");

        RequestHead requestHead = new RequestHead();
        requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

        SDKRequest request = new SDKRequest();
        request.setData(requestApiData);
        request.setHead(requestHead);

        log.info("加密前: "+ JSON.toJSONString(request));
        SDKResponse result = NBOpenSDK.encryptMessage(request);
        log.info("加密后: "+JSON.toJSONString(result));

        return result.getData();
    }

}
