package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountWaterRecordOfOwnerParam;
import com.clx.performance.service.loan.OwnerLoanAccountRunningWaterRecordService;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountRunningWaterRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/ownerLoanAccountWaterRecord")
@Validated
@Api(tags = "承运端-借款账户")
public class CarrierOwnerLoanAccountWaterRecordController {
    @Autowired
    private OwnerLoanAccountRunningWaterRecordService ownerLoanAccountRunningWaterRecordService;

    @ApiOperation(value = "分页搜索货主借款账户流水列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageOwnerLoanAccountWaterOfOwner")
    public Result<PageData<OwnerLoanAccountRunningWaterRecordVO>> pageOwnerLoanAccountWaterOfOwner(@RequestBody @Validated PageOwnerLoanAccountWaterRecordOfOwnerParam param) {
        IPage<OwnerLoanAccountRunningWaterRecordVO> page = ownerLoanAccountRunningWaterRecordService.pageOwnerLoanAccountWaterOfOwner(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
