package com.clx.performance.enums.linewarn;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum LineWarnLogEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        SUSPEND(1, "暂停预警"),
        RESOLVE(2, "处理预警"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(Type::getMsg).orElse(null);
        }
    }

}
