/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.GenericCertificate;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.PBCAgent2G;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.PropertyResourceBundle;

public class TestEnvelope {
    public static void main(String[] args) throws Exception {
        TestEnvelope.test5();
    }

    public static void test5() {
        PBCAgent2G agent = new PBCAgent2G();
        agent.openSignServer("10.20.89.240", 10001, "11111111");
        String env = "MIIBlwYJKoZIhvcNAQcDoIIBiDCCAYQCAQIxggEwMIIBLAIBAoAURpa0aRFgtpfLGTE+zvjdIqLhGDEwDQYJKoZIhvcNAQEBBQAEggEAJocq3xf2brmh/smQ5br6xu6tUPjre5s+o6xkwtphk3dhAgRN7GHfIZhOO5hNgHYlNF2xYPSl0YneSJcju5v0VV6w5lkAakppZeZQvT06QnRCxPLx4q30FgqIRLd637OK4SmEo6uoye5P8E9Qs/HTF/ukMzXTWDFqWpukJx7fz0je22RUssRVHkHOTaAXxaBNkZUqKdDk8E7wZv3kPEUjZGl+jz1vGP9qpTpGhyojXsS9BawEqV+bKoNL/He8SE+nllKl+WepIcTkzxDgWKL34Fg0LRdjwxPwHCWO3kqxRCPICRfT9zmbJ1E6IpxoHW95CpJp08nxk2s/C7kMUpIYxTBLBgkqhkiG9w0BBwEwFAYIKoZIhvcNAwcECFHvlRz0pcPwgCiyIb09NwGLHVP1E3mTwwJTHQNuxDi3yJd63ns9qmyoqwvx82xYPsoP";
        Object[] ret = agent.decryptMSEnvelope(env, null);
        System.out.println("decrypt result:" + agent.getReturnCode());
        System.out.println("sign cert subject\uff1a" + ((GenericCertificate)ret[2]).getSubject());
    }

    public static void test4() {
        String dn = "CN=5year,O=syn080924,C=cn";
        PBCAgent2G agent = new PBCAgent2G();
        agent.openSignServer("10.20.89.240", 10001, "11111111");
        String env = agent.makeMSEnvelope("11111111".getBytes(), dn, dn, null, null);
        System.out.println("env:" + env);
        Object[] ret = agent.decryptMSEnvelope(env, dn);
        System.out.println("decrypt result:" + agent.getReturnCode());
        System.out.println("sign cert subject\uff1a" + ((GenericCertificate)ret[2]).getSubject());
    }

    public static void init() {
        try {
            FileInputStream in = new FileInputStream("netsignagent.properties");
            PropertyResourceBundle prb = new PropertyResourceBundle(in);
            NetSignAgent.initialize(prb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test3() throws Exception {
        NetSignResult result = NetSignAgent.makeEnvelope("1".getBytes(), "CN=5year,O=syn080924,C=cn", null);
        String env = result.getStringResult("Base64_Enveloped_Text");
        System.out.println(env);
        result = NetSignAgent.decryptEnvelope(env, "CN=5year,O=syn080924,C=cn");
        System.out.println(new String(result.getByteArrayResult("Byte_Array_Plain_Text")));
    }

    public static void test2() throws Exception {
        NetSignResult result = NetSignAgent.unsymmEncrypt("11111111".getBytes(), "C=cn,O=INFOSEC Technologies RSA,CN=rsa2048withpfx");
        System.out.println(result.getStringResult("Base64_Enveloped_Text"));
    }

    public static void test() throws Exception {
        ConsoleLogger.isDebug = true;
        ConsoleLogger.isSave = true;
        FileInputStream in = new FileInputStream("C:\\Users\\chencheng\\Desktop\\hdecdata");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        byte[] p7 = new byte[bs.length - 4];
        System.arraycopy(bs, 4, p7, 0, p7.length);
        ConsoleLogger.logBinary("env", p7);
        ConsoleLogger.saveBinary("C:\\Users\\chencheng\\Desktop\\envdata", p7);
        NetSignResult result = NetSignAgent.decryptEnvelope(Base64.encode(p7), "C=cn,O=INFOSEC Technologies RSA,CN=samedDN");
        System.out.println(new String(result.getByteArrayResult("Byte_Array_Plain_Text")));
    }

    public static void testEnvelope() {
        try {
            NetSignResult result = NetSignAgent.makeEnvelope("12345678".getBytes(), "C=cn,O=INFOSEC Technologies SM2,CN=sm2256", "SM4");
            FileOutputStream out = new FileOutputStream("E:/evn.p7b");
            byte[] bs = result.getByteArrayResult("Base64_Enveloped_Text");
            out.write(bs);
            out.flush();
            out.close();
            result = NetSignAgent.decryptEnvelope(Base64.encode(bs), "C=cn,O=INFOSEC Technologies SM2,CN=sm2256");
            System.out.println(new String(result.getByteArrayResult("Byte_Array_Plain_Text")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

