package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.PerformanceProgressDao;
import com.clx.performance.dao.PerformanceProgressLogDao;
import com.clx.performance.enums.OrderEnum;
import com.clx.performance.enums.PerformanceProgressEnum;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.model.PerformanceProgress;
import com.clx.performance.model.PerformanceProgressLog;
import com.clx.performance.param.pc.carrier.PagePerformanceProgress;
import com.clx.performance.param.pc.carrier.UpdatePerformanceProgressParam;
import com.clx.performance.service.PerformanceProgressLogService;
import com.clx.performance.service.PerformanceProgressService;
import com.clx.performance.struct.PerformanceProgressLogStruct;
import com.clx.performance.struct.PerformanceProgressStruct;
import com.clx.performance.vo.pc.PerformanceProgressDetailVO;
import com.clx.performance.vo.pc.PerformanceProgressOperationLogVO;
import com.clx.performance.vo.pc.PerformanceProgressVO;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
@Service
@Slf4j
@AllArgsConstructor
public class PerformanceProgressServiceImpl  implements PerformanceProgressService {

    private final PerformanceProgressDao performanceProgressDao;
    private final PerformanceProgressStruct performanceProgressStruct;
    private final PerformanceProgressLogDao performanceProgressLogDao;
    private final PerformanceProgressLogStruct performanceProgressLogStruct;
    private final PerformanceProgressLogService performanceProgressLogService;


    public static List<Integer> inProcessStatusList;
    public static List<Integer> endStatusList ;
    public static List<Integer> allStatusList ;


    static {
       inProcessStatusList = Arrays.asList(
                OrderEnum.Status.PLATFORM_UNDERTAKING.getCode(),
                OrderEnum.Status.SUSPEND.getCode(),
                OrderEnum.Status.ON_ORDER.getCode(),
                OrderEnum.Status.IN_TRANSIT.getCode());

        endStatusList = Arrays.asList(
                OrderEnum.Status.SUCCESS.getCode(),
                OrderEnum.Status.COMPLETED.getCode());


        allStatusList = Arrays.asList(
                OrderEnum.Status.PLATFORM_UNDERTAKING.getCode(),
                OrderEnum.Status.SUSPEND.getCode(),
                OrderEnum.Status.ON_ORDER.getCode(),
                OrderEnum.Status.IN_TRANSIT.getCode(),
                OrderEnum.Status.SUCCESS.getCode(),
                OrderEnum.Status.COMPLETED.getCode());

    }


    @Override
    public IPage<PerformanceProgressVO> pagePerformanceProgress(PagePerformanceProgress param) {

        IPage<PerformanceProgress> page = new Page<>();
        IPage<PerformanceProgressVO> returnPage = new Page<>();


        if(Objects.equals(param.getTab(), PerformanceProgressEnum.Tab.IN_PROCESS.getCode())){
            param.setPage(1);
            param.setPageSize(10000);
            page =  performanceProgressDao.pagePerformanceProgress(inProcessStatusList,param);

        }else if(Objects.equals(param.getTab(), PerformanceProgressEnum.Tab.END.getCode())){
            page =  performanceProgressDao.pagePerformanceProgress(endStatusList,param);

        }else if(Objects.equals(param.getTab(), PerformanceProgressEnum.Tab.ALL.getCode())){
            page =  performanceProgressDao.pagePerformanceProgress(allStatusList,param);

        }
        if(CollectionUtils.isEmpty(page.getRecords())){
            return returnPage;
        }

        List<PerformanceProgressVO> records = performanceProgressStruct.convertList(page.getRecords());

        returnPage.setPages(page.getPages());
        returnPage.setTotal(page.getTotal());
        returnPage.setRecords(records);


        //如果查询的是 已结束线路,则不需要计算，直接返回
        if(Objects.equals(param.getTab(), PerformanceProgressEnum.Tab.END.getCode())){
            return returnPage;
        }

        returnPage.getRecords().forEach(item ->{
            //TODO  进行订单运费预估调用  开发批量调用的接口。 订单完结完成后把运费预估查询出来的数据存入到数据库，后续不再实时查询
            if(inProcessStatusList.contains(item.getOrderStatus())){  //进行中的订单线路

            }
        });

        return returnPage;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateAdjustOrder(Integer adjustOrderId, Integer adjustOrderBeforeId) {
        Optional<PerformanceProgress> one = performanceProgressDao.getEntityByKey(adjustOrderId);
        //如果上调，这条记录传的是移动数据后面的记录id，如果下调，这条记录传的是移动数据前面的记录id
        Optional<PerformanceProgress> two = performanceProgressDao.getEntityByKey(adjustOrderBeforeId);
        if(!one.isPresent() || !two.isPresent()){
            throw new ServiceSystemException(ResultEnum.DATA_NOT_FIND);
        }
        boolean isUp = false;
        //通过seq判断是上调还是下调
        if(one.get().getSeq()  <  two.get().getSeq()){
            isUp = true;
        }
        //上调：大于two 这条记录的seq + 1 ； 下调：大于等于two这条记录的seq + 1 ;
        performanceProgressDao.updateRecordOrder(two.get().getSeq(),isUp);
        if(isUp){   //上调
            //调整的记录使用 two 的seq + 1;
            PerformanceProgress updateOne = new PerformanceProgress();
            updateOne.setId(one.get().getId());
            updateOne.setSeq(two.get().getSeq() + 1);
            performanceProgressDao.updateEntityByKey(updateOne);
        }else{    //下调
            //调整的记录使用 two 的seq;
            PerformanceProgress updateOne = new PerformanceProgress();
            updateOne.setId(one.get().getId());
            updateOne.setSeq(two.get().getSeq());
            performanceProgressDao.updateEntityByKey(updateOne);
        }
    }

    //通过dts监听订单、货单、运单表进行更新履约进度表的数据
    @Override
    public void saveOrUpdatePerformanceProgress(PerformanceProgress item) {
        Optional<PerformanceProgress> optional = performanceProgressDao.getOneByField(PerformanceProgress::getOrderNo,
                item.getOrderNo());
        if(optional.isPresent()){
            item.setId(optional.get().getId());
            performanceProgressDao.updateEntityByKey(item);
        }else{
            performanceProgressDao.saveEntity(item);
        }
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updatePerformanceProgress(UpdatePerformanceProgressParam param, Long userNo, String userName) {
        PerformanceProgress item = performanceProgressDao.getEntityByKey(param.getId()).
                orElseThrow(ResultEnum.DATA_NOT_FIND);
        PerformanceProgress update = new PerformanceProgress();
        List<PerformanceProgressLog> logs = new ArrayList<>();
        boolean change = false;
        if(Objects.nonNull(item.getTodayExpectComplete())
                && Objects.nonNull(param.getTodayExpectComplete())
                && item.getTodayExpectComplete().compareTo(param.getTodayExpectComplete()) != 0){
            PerformanceProgressLog log = performanceProgressLogService.generateLog(item.getOrderNo(),
                    PerformanceProgressEnum.LogType.TODAY_EXPECT_COMPLETE,
                    param.getTodayExpectComplete(),userNo,userName);
            update.setTodayExpectComplete(param.getTodayExpectComplete());
            logs.add(log);
            change = true;
        }

        if(Objects.equals(item.getTradeRequireArriveStationTime(),param.getTradeRequireArriveStationTime())){
            PerformanceProgressLog log = performanceProgressLogService.generateLog(item.getOrderNo(),
                    PerformanceProgressEnum.LogType.TRADE_REQUIRE_ARRIVE_STATION_TIME,
                    param.getTradeRequireArriveStationTime(),userNo,userName);
            update.setTradeRequireArriveStationTime(param.getTradeRequireArriveStationTime());
            logs.add(log);
            change = true;
        }

        if(Objects.equals(item.getTransportExpectArriveStationTime(),param.getTransportExpectArriveStationTime())){
            PerformanceProgressLog log = performanceProgressLogService.generateLog(item.getOrderNo(),
                    PerformanceProgressEnum.LogType.TRADE_REQUIRE_ARRIVE_STATION_TIME,
                    param.getTransportExpectArriveStationTime(),userNo,userName);
            update.setTransportExpectArriveStationTime(param.getTransportExpectArriveStationTime());
            logs.add(log);
            change = true;
        }

        if(Objects.equals(item.getAbnormalRemark(),param.getAbnormalRemark())){
            PerformanceProgressLog log = performanceProgressLogService.generateLog(item.getOrderNo(),
                    PerformanceProgressEnum.LogType.ABNORMAL_REMARK,
                    param.getAbnormalRemark(),userNo,userName);
            update.setAbnormalRemark(param.getAbnormalRemark());
            logs.add(log);
            change = true;
        }
        if(Objects.equals(item.getPerformanceAbnormalReason(),param.getPerformanceAbnormalReason())){
            PerformanceProgressLog log = performanceProgressLogService.generateLog(item.getOrderNo(),
                    PerformanceProgressEnum.LogType.PERFORMANCE_ABNORMAL_REASON,
                    param.getPerformanceAbnormalReason(),userNo,userName);
            update.setPerformanceAbnormalReason(param.getPerformanceAbnormalReason());
            logs.add(log);
            change = true;
        }
        if(Objects.equals(item.getDispatchFollow(),param.getDispatchFollow())){
            PerformanceProgressLog log = performanceProgressLogService.generateLog(item.getOrderNo(),
                    PerformanceProgressEnum.LogType.DISPATCH_FOLLOW,
                    param.getDispatchFollow(),userNo,userName);
            update.setDispatchFollow(param.getDispatchFollow());
            logs.add(log);
            change = true;
        }

        if(change){
            performanceProgressDao.updateEntityByKey(update);
            performanceProgressLogDao.saveBatchList(logs);
        }
    }

    @Override
    public PerformanceProgressDetailVO getPerformanceProgressDetail(Integer id) {
        PerformanceProgress item = performanceProgressDao.getEntityByKey(id).orElseThrow(ResultEnum.DATA_NOT_FIND);
        return performanceProgressStruct.convert(item);
    }

    @Override
    public List<PerformanceProgressOperationLogVO> getOperationLog(String orderNo) {
        List<PerformanceProgressLog> list = performanceProgressLogDao.getOperationLog(orderNo);
        return performanceProgressLogStruct.convertList(list);
    }
}
