package com.clx.performance.model.vehiclewarn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 预警日志
* @Date: 2024/04/26 10:32:01
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class VehicleWarnLog  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Integer infoId;                         //预警信息id
    private Integer type;                           //类型：1暂停预警 2处理预警
    private String childNo;                         //运单编号
    private String warnName;                        //预警名称
    private LocalDateTime warnTime;                 //预警时间
    private Integer warnRang;                       //预警屏蔽范围：1运单 2货单 3无预警
    private LocalDateTime warnEndTime;              //预警屏蔽结束时间
    private String content;                         //内容
    private String createBy;                        //创建人
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
