package com.clx.performance.vo.pc.loan.owner;

import com.clx.performance.enums.loan.OwnerLoanAccountRunningWaterRecordEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @ClassName OwnerLoanRunWaterRecordVO
 * @Description
 * @Author kavin
 * @Date 2024/1/23 13:21
 * @Version 1.0
 */
@Getter
@Setter
public class OwnerLoanRunWaterRecordVO {



    private Integer id;

    @ApiModelProperty("货主编码")
    private String ownerUserNo;

    
    @ApiModelProperty("货主名称")
    private String ownerUserName;

    
    @ApiModelProperty("联系电话")
    private String mobile;

    
    @ApiModelProperty("流水号")
    private Long runningWaterNo;

    
    @ApiModelProperty("借款单号")
    private Long loanNo;

    
    @ApiModelProperty("运单编号")
    private String childNo;

    
    @ApiModelProperty("流水类型")
    private Integer runningWaterType;


    @ApiModelProperty("流水类型")
    private String runningWaterTypeMsg;

    public String getRunningWaterTypeMsg() {
        return OwnerLoanAccountRunningWaterRecordEnum.RunWaterType.getMsgByCode(runningWaterType);
    }


    @MoneyOutConvert
    @ApiModelProperty("金额")
    private BigDecimal alterationBalance;

    @MoneyOutConvert
    @ApiModelProperty("账户余额")
    private BigDecimal accountBalance;

    @MoneyOutConvert
    @ApiModelProperty("可用余额")
    private BigDecimal useAbleBalance;


    @MoneyOutConvert
    @ApiModelProperty("冻结余额")
    private BigDecimal frozenBalance;

    
    @ApiModelProperty("创建人")
    private String createBy;

    
    @ApiModelProperty("创建时间")
    private String createTime;

    
    @ApiModelProperty("修改时间")
    private String modifiedTime;
}
