package com.clx.performance.vo.pc.carrier.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @ClassName CarrierPageSettlementOwnerDetailVO
 * @Description
 * @Author kavin
 * @Date 2023/10/16 15:01
 * @Version 1.0
 */
@Getter
@Setter
public class CarrierPageSettlementOwnerVO {
    @ApiModelProperty(value = "结算单Id")
    private Integer id;
    @ApiModelProperty(value = "结算单号")
    private String settlementNo;
    @ApiModelProperty(value = "开票标识：1网运单 2普通单")
    private Integer invoiceType;
    @ApiModelProperty(value = "货主编码")
    private Long ownerUserNo;
    @ApiModelProperty(value = "货主姓名")
    private String ownerName;
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
    @ApiModelProperty(value = "实际净重（吨）")
    private BigDecimal weight;
    @MoneyOutConvert
    @ApiModelProperty(value = "实际运费金额")
    private BigDecimal freight;
    @MoneyOutConvert
    @ApiModelProperty(value = "预付运费金额")
    private BigDecimal prepayFreight;
    @ApiModelProperty(value = "货损吨数（吨）")
    private BigDecimal lossWeight;
    @MoneyOutConvert
    @ApiModelProperty(value = "货损金额")
    private BigDecimal lossFreight;
    @MoneyOutConvert
    @ApiModelProperty(value = "结算金额")
    private BigDecimal settlementFreight;
    @MoneyOutConvert
    @ApiModelProperty(value = "借款金额")
    private BigDecimal loanFreight;
    @MoneyOutConvert
    @ApiModelProperty(value = "开票金额")
    private BigDecimal invoiceFreight;
    @MoneyOutConvert
    @ApiModelProperty(value = "开票服务费")
    private BigDecimal invoiceServiceFee;

    @ApiModelProperty(value = "创建时间")
    private String createTime;
    @ApiModelProperty(value = "状态 10:待锁定  20:待对账  30:待货主确认 40:待货主付款 50:待平台确认付款 60:待平台付款 70:待货主确认付款 80:待邮寄发票 90:已完结")
    private Integer status;
    @ApiModelProperty("结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;
    @ApiModelProperty("开票公司简称")
    private String invoicingCompanyShorterName;
    @ApiModelProperty("开票公司统一社会信用代码")
    private String invoicingCompanyGroupCode;
    @ApiModelProperty("是否上报 0-否;1-是")
    private Integer reportFlag;

}
