package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
@Getter
@Setter
public class PerformanceProgressVO{

    private Integer id;

    
    @ApiModelProperty("排序")
    private Integer seq;

    
    @ApiModelProperty("订单编号")
    private String orderNo;


    @ApiModelProperty("订单状态： 0待报价 1客户确认中 2报价已确认 3平台已承接 4已取消 5暂停 6拒绝承运 7 挂单中 8运输中 9订单已完成 10 已失效")
    private Integer orderStatus;
    
    @ApiModelProperty("发货-地址id")
    private Integer sendAddressId;

    
    @ApiModelProperty("货源地简称")
    private String sendAddressShorter;

    
    @ApiModelProperty("货源地-标准地址id")
    private Integer sendSystemAddressId;

    
    @ApiModelProperty("货源地-标准地址简称")
    private String sendSystemAddressShorter;

    
    @ApiModelProperty("高级物流经理姓名数组")
    private String seniorLogisticsManagerName;

    
    @ApiModelProperty("货物类型编码")
    private String goodsTypeCode;

    
    @ApiModelProperty("货物类型名称")
    private String goodsTypeName;

    
    @ApiModelProperty("货物名称id")
    private Integer goodsNameId;

    
    @ApiModelProperty("货物名称")
    private String goodsName;

    
    @ApiModelProperty("煤源位置")
    private String sendAddress;

    
    @ApiModelProperty("是否C类煤源  0 否  1 是")
    private Integer sendOverStandard;

    
    @ApiModelProperty("司机运费")
    private BigDecimal driverFreightPrice;

    
    @ApiModelProperty("任务吨数")
    private BigDecimal taskWeight;

    
    @ApiModelProperty("任务吨数")
    private BigDecimal transportWeight;

    
    @ApiModelProperty("挂单吨数")
    private BigDecimal pendingWeight;

    
    @ApiModelProperty("接单车数")
    private Integer orderedTruckNum;

    
    @ApiModelProperty("到达货源地车数")
    private Integer arriveSendTruckNum;

    
    @ApiModelProperty("装车车数")
    private Integer loadTruckNum;

    
    @ApiModelProperty("卸车车数")
    private Integer unloadTruckNum;

    
    @ApiModelProperty("在途车数")
    private Integer onTheWayTruckNum;

    
    @ApiModelProperty("接单率")
    private BigDecimal orderedRate;

    
    @ApiModelProperty("任务完成率")
    private BigDecimal taskCompleteRatio;

    
    @ApiModelProperty("矿发吨数")
    private BigDecimal sumLoadWeight;

    
    @ApiModelProperty("到站吨数")
    private BigDecimal sumUnloadWeight;

    
    @ApiModelProperty("在途吨数")
    private BigDecimal sumOnTheWayWeight;

    
    @ApiModelProperty("今日预计完成吨数")
    private BigDecimal todayExpectComplete;

    
    @ApiModelProperty("异常备注")
    private String abnormalRemark;

    
    @ApiModelProperty("履约异常原因")
    private String performanceAbnormalReason;

    
    @ApiModelProperty("调度备注/跟进措施")
    private String dispatchFollow;

    
    @ApiModelProperty("重车运距(公里)")
    private BigDecimal orderDistance;

    
    @ApiModelProperty("可拉运时间段")
    private String transportTimeSlot;

    
    @ApiModelProperty("挂单时间")
    private LocalDateTime pendingTime;

    
    @ApiModelProperty("交易要求到站时间")
    private String tradeRequireArriveStationTime;

    
    @ApiModelProperty("交易要求到站时间")
    private String transportExpectArriveStationTime;

    
    @ApiModelProperty("测算运费")
    private BigDecimal predictionFreightPrice;

    
    @ApiModelProperty("创建时间")
    private String createTime;

    
    @ApiModelProperty("修改时间")
    private String modifiedTime;

}
