package com.clx.performance.vo.app;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildPoundInfoVO {

    @ApiModelProperty(value = "装货毛重（单位吨）", example = "1.23")
    private BigDecimal loadRough;
    @ApiModelProperty(value = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;
    @ApiModelProperty(value = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;
    @ApiModelProperty(value = "卸货毛重（单位吨）", example = "1.23")
    private BigDecimal unloadRough;
    @ApiModelProperty(value = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;
    @ApiModelProperty(value = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;
    @ApiModelProperty(value = "卸货磅单编号", example = "url")
    private String unloadPoundNo;

    @ApiModelProperty(value = "拉运重量（单位吨）", example = "1.23")
    private BigDecimal weight;
    @ApiModelProperty(value = "运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freight;

    @ApiModelProperty(value = "磅单审核状态 0 待审核 1 审核通过 2 审核驳回", example = "0")
    private Integer poundStatus;
    @ApiModelProperty(value = "磅单审核驳回原因", example = "交货信息错误")
    private String poundRemark;
    @ApiModelProperty(value = "磅单审核驳回类型：1装车 2卸车 3装车+卸车", example = "1")
    private Integer poundRejectType;

    @ApiModelProperty(value = "状态", example = "0")
    private Integer status;

    @ApiModelProperty(value = "装车磅单图片列表")
    private List<String> loadImageList;

    @ApiModelProperty(value = "卸车磅单图片列表")
    private List<String> unloadImageList;

    @ApiModelProperty(value = "到达货源地时间")
    private LocalDateTime arriveSendTime;

    @ApiModelProperty(value = "首次装货时间")
    private LocalDateTime firstLoadTime;

    @ApiModelProperty(value = "到达目的地时间")
    private LocalDateTime arriveReceiveTime;

    @ApiModelProperty(value = "首次交货时间")
    private LocalDateTime firstUnloadTime;
}