package com.clx.performance.param.pc.customer;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @ClassName saveCustomerComplaintDetailParam
 * @Description
 * @Author kavin
 * @Date 2023/12/8 13:52
 * @Version 1.0
 */

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SaveCustomerComplaintDetailParam {

    @NotNull(message = "投诉类型ID不能为空")
    @ApiModelProperty("投诉类型ID")
    private Integer complaintTypeId;             //投诉类型id

    @ApiModelProperty("运单编号")
    private String childNo;                         //运单编号

    @Size(min=1 ,max = 1000)
    @ApiModelProperty("运单编号")
    private String content;                      //问题描述

    @ApiModelProperty("图片")
    private List<String> picture;                      //图片

}
