package com.clx.performance.vo.pc.broker;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OpenOrderChildDTO {

    private String sourceChildNo;
    @Schema(description = "源货单编号", example = "1234", required = true)
    private String sourceGoodsNo;
    @Schema(description = "源订单编号", example = "1234", required = true)
    private String sourceOrderNo;
    @Schema(description = "源结算单编号", example = "1234", required = true)
    private String sourceSettlementNo;
    @Schema(description = "订单来源", example = "1234")
    private Integer orderSource;

    @Schema(description = "运费单价（分/吨）", example = "162", required = true)
    private Integer freightPrice;
    @Schema(description = "运费（分）", example = "162", required = true)
    private Integer freight;
    @Schema(description = "司机运费（分）",  example = "123")
    private Integer driverFreight;
    @Schema(description = "司机运费单价（分/吨）",  example = "123")
    private Integer driverFreightPrice;
    @Schema(description = "开票金额（分）", example = "162", required = true)
    private Integer invoiceFreight;
    @Schema(description = "亏吨扣款（分）",  example = "123")
    private Integer lossFee;
    @Schema(description = "货损单价（分/吨）",  example = "123")
    private Integer lossFeePrice;
    @Schema(description = "管理费（分）",  example = "123")
    private Integer invoiceServiceFee;

    @Schema(description = "发货皮重（吨）")
    private BigDecimal sendTare;
    @Schema(description = "发货毛重（吨）")
    private BigDecimal sendRough;
    @Schema(description = "发货净重（吨）")
    private BigDecimal sendNet;

    @Schema(description = "接单时间")
    private String payTime;
    @Schema(description = "装车时间")
    private String loadTime;
    @Schema(description = "卸车时间")
    private String unloadTime;
    @Schema(description = "运单完成时间", example = "2020-02-02 10:10:10", required = true)
    private String payFinishedTime;
    @Schema(description = "磅单审核时间", example = "2020-02-02 10:10:10", required = true)
    private String poundTime;

    @Schema(description = "收货皮重（吨）")
    private BigDecimal receiveTare;
    @Schema(description = "收货毛重（吨）")
    private BigDecimal receiveRough;
    @Schema(description = "收货净重（吨）")
    private BigDecimal receiveNet;
    @Schema(description = "实收净重（吨）")
    private BigDecimal realNet;

    @Schema(description = "备注", example = "", required = true)
    private String remark;

    @Schema(description = "1 普通单 2 网运单", example = "1", required = true)
    private Integer invoiceFlag;
    @Schema(description = "线下平台", example = "华祥", required = true)
    private String invoicePlatform;

    @Schema(description = "开票状态 0 未开票 1 已开票 ", example = "1")
    private Integer invoiceStatus;

    @Schema(description = "结算状态 1 已结算 ", example = "1234124")
    private Integer settleStatus;

    @Schema(description = "是否需要开票配置 0:否 1:是", example = "1", required = true)
    private Integer invoiceNeed;

    @Schema(description = "预估运费单价（分/吨）", example = "162", required = true)
    private Integer predictFreightPrice;

}
