package com.clx.performance.param.pc;


import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import jakarta.validation.constraints.NotNull;

@Data
public class ArtificialCancelOrderQueryParam {

    @Schema(description="运单编号")
    private String orderChildNo;

    @Schema(description="车牌号")
    private String truckNo;

    public void checkParam() {
        if (orderChildNo == null && truckNo == null) {
            throw new IllegalArgumentException("运单编号和车牌号不能同时为空");
        }
    }
}
