package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Data
public class SendMobileCaptchaParam {

    @Schema(description = "手机号", example = "1")
    @NotBlank(message = "手机号")
    private String mobile;

    @Schema(description = "会话ID", required = true, example = "XXX")
    private String sessionId;
    @Schema(description = "签名串", required = true, example = "XXX")
    private String sig;
    @Schema(description = "请求唯一标识", required = true, example = "XXX")
    private String token;
    @Schema(description = "场景标识", required = true, example = "XXX")
    private String scene;

}
