package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum BreakContractSettlementOwnerEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {
        TO_BE_ACCOUNT(10, "待对账"),
        OWNER_TO_BE_CONFIRMED(20, "待货主确认"),
        SHIPPER_TO_PAYMENT (30, "待货主付款"),
        PLATFORM_CONFIRMED_OWNER_PAYMENT(40, "待平台确认付款"),
        PLATFORM_TO_PAYMENT(50, "待平台付款"),
        OWNER_CONFIRMED_PLATFORM_PAYMENT(60, "待货主确认付款"),
        COMPLETED(70, "已完结"),
        CANCEL(80, "已取消"),

        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }



}
