package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 货主充值
 *
 * @date : 2023-10-12
 */

@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_top_up")
public class OwnerTopUp implements HasKey<Integer> {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 充值编号
     */
    @TableField("top_up_no")
    private Long topUpNo;
    /**
     * 货主编码
     */
    @TableField("owner_user_no")
    private Long ownerUserNo;
    /**
     * 充值类型
     */
    @TableField("account_type")
    private Integer accountType;
    /**
     * 充值金额
     */
    @TableField("top_up_balance")
    private BigDecimal topUpBalance;
    /**
     * 状态
     */
    @TableField("status")
    private Integer status;
    /**
     * 打款银行
     */
    @TableField("drawing_bank")
    private String drawingBank;
    /**
     * 打款银行卡号
     */
    @TableField("drawing_bank_number")
    private String drawingBankNumber;
    /**
     * 打款凭证
     */
    @TableField("drawing_proof")
    private String drawingProof;
    /**
     * 操作时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;
    /**
     * 操作人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 公司名称
     */
    @TableField("company_name")
    private String companyName;
    /**
     * 审批时间
     */
    @TableField("approval_time")
    private LocalDateTime approvalTime;
    /**
     * 审批人
     */
    @TableField("approval_by")
    private String approvalBy;
    /**
     * 审批拒绝
     */
    @TableField("approval_turn_down")
    private String approvalTurnDown;

    /**
     * 修改时间
     */
    @TableField("modified_time")
    private LocalDateTime modifiedTime;

    /**
     * 收款人企业信息
     */
    @TableField("enterprise_name")
    private String enterpriseName;

    /**
     *收款人开户行
     */
    @TableField("open_account_bank")
    private String openAccountBank;

    /**
     * 收款人开户行银行代码
     */
    @TableField("open_account_bank_number")
    private String openAccountBankNumber;

    /**
     * 收款人账户账号
     */
    @TableField("account_number")
    private String accountNumber;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}
