package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.breakcontract.carrier.*;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerService;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerVO;
import com.clx.performance.vo.pc.owner.settle.SettlementPlatformAccountVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract")
@Validated
@Tag(name = "承运端-违约结算单（货主）")
@AllArgsConstructor
public class CarrierBreakContractSettlementOwnerController {

    private final BreakContractSettlementOwnerService breakContractSettlementOwnerService;


    @Operation(summary = "列表",description = "<br>By:李瑞新")
    @PostMapping("/pageCarrierBreakContractSettlementOwnerList")
    @UnitCovert(param = false)
    public Result<PageData<PageCarrierBreakContractSettlementOwnerVO>> pageCarrierBreakContractSettlementOwnerList(@RequestBody PageCarrierBreakContractSettlementOwnerParam param) {
        IPage<PageCarrierBreakContractSettlementOwnerVO> page = breakContractSettlementOwnerService.pageCarrierBreakContractSettlementOwnerList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "导出")
    @PostMapping("/exportCarrierBreakContractSettlementOwnerList")
    public Result exportCarrierBreakContractSettlementOwnerList(@RequestBody  PageCarrierBreakContractSettlementOwnerParam param, HttpServletResponse response) throws Exception {

        SXSSFWorkbook workbook = breakContractSettlementOwnerService.exportCarrierBreakContractSettlementOwnerList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return null;
    }


    @Operation(summary = "详情",description = "<br>By:李瑞新")
    @GetMapping("/getCarrierBreakContractSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierBreakContractSettlementOwnerDetailVO> getCarrierBreakContractSettlementOwnerDetail(@NotBlank(message = "结算单号不能为空") String settlementNo) {
        return Result.ok(breakContractSettlementOwnerService.getCarrierBreakContractSettlementOwnerDetail(settlementNo));
    }

    @Operation(summary = "上传结算凭证",description = "<br>By:李瑞新")
    @PostMapping("/uploadInvoiceImg")
    public Result uploadInvoiceImg(@RequestBody @Validated CarrierUploadInvoiceImgParam param) {
        breakContractSettlementOwnerService.uploadInvoiceImg(param);
        return Result.ok();
    }

    @Operation(summary = "取消结算单",description = "<br>By:李瑞新")
    @PostMapping("/updateCancelSettlement")
    public Result updateCancelSettlement(@RequestBody @Validated CarrierCancelSettlementParam param) {
        breakContractSettlementOwnerService.updateCancelSettlement(param);
        return Result.ok();
    }


    @Operation(summary = "付款",description = "<br>By李瑞新")
    @PostMapping("/saveCarrierBreakContractPayee")
    public Result saveCarrierBreakContractPayee(@RequestBody @Validated CarrierBreakContractSavePayeeParam param) {
        breakContractSettlementOwnerService.saveCarrierBreakContractPayee(param);
        return Result.ok();
    }

    @Operation(summary = "付款确认",description = "<br>By:李瑞新")
    @PostMapping("/updateCarrierBreakContractPayeeConfirm")
    public Result updateCarrierBreakContractPayeeConfirm(@RequestBody @Validated CarrierBreakPayeeConfirmParam param ) {
        breakContractSettlementOwnerService.updateCarrierBreakContractPayeeConfirm(param);
        return Result.ok();
    }

    @Operation(summary = "获取结算平台收款账号",description = "<br>By:李瑞新")
    @GetMapping("/getSettlementPlatformAccount")
    public Result<SettlementPlatformAccountVO> getSettlementPlatformAccount(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(breakContractSettlementOwnerService.getCarrierSettlementPlatformAccount(id));
    }

}
