package com.clx.performance.controller.feign;

import cn.hutool.json.JSONUtil;
import com.clx.performance.param.pc.driver.NetworkDriverAccountParam;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.service.settle.NetworkDriverAccountService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/feign/driver")
@Validated
@AllArgsConstructor
public class DriverAccountFeignController {

    private final NetworkDriverAccountService networkDriverAccountService;


    @Operation(summary = "创建司机网络货运账户", description = "<br>By:胡宇帆")
    @PostMapping("/createNetworkDriverAccount")
    public Result<Object> createNetworkDriverAccount(@RequestBody NetworkDriverAccountParam param) {
        log.info("进行创建司机网络货运账户,相关参数{}", JSONUtil.parse(param).toString());
        networkDriverAccountService.createNetworkDriverAccount(param);
        return Result.ok();
    }

}
