package com.clx.performance.param.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

@Getter
@Setter
@NoArgsConstructor
public class IntegralTruckAddParam {

    @ApiModelProperty(value = "车牌号", example = "京A12345")
    @NotBlank(message = "车牌号不能为空")
    private String truckNo;
    @ApiModelProperty(value = "司机姓名", example = "张三")
    @NotBlank(message = "司机姓名不能为空")
    private String driverName;
    @ApiModelProperty(value = "司机手机号", example = "13000000000")
    @NotBlank(message = "司机手机号不能为空")
    private String driverMobile;

}
