package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description:
* @Date: 2024/02/06 15:31:16
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class BankTrade implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Integer orderType;                      //订单类型
    private Integer tradeType;                      //交易类型
    private String merchantRunningWaterNo;          //商户流水号
    private String runningWaterOpenNo;              //交易流水号（第三方）
    private BigDecimal amount;                      //金额
    private Integer status;                         //状态
    private String remark;                          //备注
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间
    private String relationNo;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}