package com.clx.performance.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.clx.performance.enums.loan.OwnerLoanAccountRunningWaterRecordEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @ClassName OwnerLoanAccountRunWaterRecordDTO
 * @Description
 * @Author kavin
 * @Date 2024/1/23 14:05
 * @Version 1.0
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class OwnerLoanAccountRunWaterRecordDTO {

    @ColumnWidth(25)
    @ExcelProperty("货主编码")
    private String ownerUserNo;

    @ColumnWidth(25)
    @ExcelProperty("货主名称")
    private String ownerUserName;

    @ColumnWidth(25)
    @ExcelProperty("联系电话")
    private String mobile;

    @ColumnWidth(25)
    @ExcelProperty("流水号")
    private String runningWaterNo;


    @ColumnWidth(25)
    @ExcelProperty("运单编号")
    private String childNo;

    @ExcelIgnore
    private Integer runningWaterType;

    @ColumnWidth(25)
    @ExcelProperty("流水类型")
    private String runningWaterTypeMsg;

    public String getRunningWaterTypeMsg(){
        return OwnerLoanAccountRunningWaterRecordEnum.RunWaterType.getMsgByCode(runningWaterType);
    }
    @ColumnWidth(25)
    @ExcelProperty("金额")
    private BigDecimal alterationBalance;

    public BigDecimal getAlterationBalance(){
        return Objects.isNull(alterationBalance)? null : alterationBalance.movePointLeft(2);
    }
    @ColumnWidth(25)
    @ExcelProperty("冻结余额")
    private BigDecimal frozenBalance;

    public BigDecimal getFrozenBalance(){
        return Objects.isNull(frozenBalance)? null : frozenBalance.movePointLeft(2);
    }

    @ColumnWidth(25)
    @ExcelProperty("可用余额")
    private BigDecimal useAbleBalance;

    public BigDecimal getUseAbleBalance(){
        return Objects.isNull(useAbleBalance)? null : useAbleBalance.movePointLeft(2);
    }

    @ColumnWidth(25)
    @ExcelProperty("账户余额")
    private BigDecimal accountBalance;

    public BigDecimal getAccountBalance(){
        return Objects.isNull(accountBalance)? null : accountBalance.movePointLeft(2);
    }


    @ColumnWidth(25)
    @ExcelProperty("操作人")
    private String createBy;

    @ColumnWidth(25)
    @ExcelProperty("操作时间")
    private String createTime;

    @ColumnWidth(25)
    @ExcelProperty("借款单号")
    private String loanNo;


}
