package com.clx.performance.vo.pc.linewarn;

import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 线路预警配置
* @Date: 2024/05/29 10:55:33
* @Version: 1.0
*/

@Getter
@Setter
@ToString
@NoArgsConstructor
public class LineWarnConfigVO {

    @ApiModelProperty(value = "id", example = "1")
    private Integer id;
    @ApiModelProperty(value = "预警方案名称", example = "接单预警")
    private String warnName;
    @ApiModelProperty(value = "预警类型: 1接单预警 2装车预警 3卸车预警 4拥堵预警 5天气预警 6运单异常 7线路异常", example = "1")
    private Integer warnType;
    @ApiModelProperty(value = "预警类型: 1接单预警 2装车预警 3卸车预警 4拥堵预警 5天气预警 6运单异常 7线路异常", example = "接单预警")
    private String warnTypeMsg;
    public String getWarnTypeMsg() {
        return LineWarnConfigEnum.WarnType.getMsgByCode(warnType);
    }
    @ApiModelProperty(value = "预警级别", example = "")
    private Integer warnLevel;
    @ApiModelProperty(value = "预警级别", example = "一级")
    private String warnLevelMsg;
    public String getWarnLevelMsg() {
        if (warnLevel == 1) {return "一级";}
        if (warnLevel == 2) {return "二级";}
        if (warnLevel == 3) {return "三级";}
        return null;
    }
    @ApiModelProperty(value = "预警间隔（小时）", example = "1.1")
    private BigDecimal interval;
    @ApiModelProperty(value = "时间占比（%）", example = "1.2")
    private BigDecimal timeRatio;
    @ApiModelProperty(value = "任务完成占比", example = "1.3")
    private BigDecimal taskCompleteRatio;
    @ApiModelProperty(value = "交通增加时间（分钟）", example = "1")
    private Integer congestionTime;

    @ApiModelProperty(value = "状态：1启用 2禁用", example = "1")
    private Integer status;
    @ApiModelProperty(value = "状态：1启用 2禁用", example = "启用")
    private String statusMsg;
    public String getStatusMsg() {
        return LineWarnConfigEnum.Status.getMsgByCode(status);
    }
    @ApiModelProperty(value = "创建人", example = "")
    private String createBy;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

    @Getter
    @Setter
    @NoArgsConstructor
    public static class WarnTypeItem {
        @ApiModelProperty(value = "报警类型", example = "1")
        private Integer warnType;
        @ApiModelProperty(value = "报警类型名称", example = "超时")
        private String warnTypeName;

        public WarnTypeItem(Integer warnType, String warnTypeName) {
            this.warnType = warnType;
            this.warnTypeName = warnTypeName;
        }
    }
}