package com.clx.performance.vo.pc.breakcontract.carrier;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BreakContractOwnerRecordVO {

    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("触发类型：1系统触发 2手动触发")
    private Integer triggerType;

    @ApiModelProperty("违约方类型：1平台 2货主 3司机")
    private Integer breakContractPartyType;

    @ApiModelProperty("违约订单")
    private String orderNo;

    @ApiModelProperty("违约金（分）")
    @MoneyOutConvert
    private BigDecimal figure;

    @ApiModelProperty("结算单编号")
    private String settlementNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("确认状态：0-确认中;1-已经确认;2-已驳回")
    private Integer confirmStatus;

    @ApiModelProperty("驳回原因")
    private String rejectReason;

}
