package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildSaveParam extends PositionParam {

    @ApiModelProperty(value = "货单编号", example = "100000000")
    @NotBlank(message = "货单编号不能为空")
    private String orderGoodsNo;

    @ApiModelProperty(value = "车辆id", example = "1")
    @NotNull(message = "车辆id空")
    private Integer truckId;

    @ApiModelProperty(value = "司机用户编号", example = "1")
    @NotNull(message = "司机用户编号空")
    private Long driverUserNo;

}
