package com.clx.performance.dao.impl.loan;


import com.clx.performance.dao.loan.BankTradeDao;
import com.clx.performance.mapper.loan.BankTradeMapper;
import com.clx.performance.model.loan.BankTrade;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @Author: aiqinguo
 * @Description:
 * @Date: 2024/01/17 13:42:57
 * @Version: 1.0
 */
@Repository
public class BankTradeDaoImpl extends BaseDaoImpl<BankTradeMapper, BankTrade, Integer> implements BankTradeDao {

    @Override
    public boolean updateStatus(BankTrade item) {
        return update(lUdWrapper()
                .eq(BankTrade::getId, item.getId())
                .set(BankTrade::getStatus, item.getStatus())
        );
    }

    @Override
    public Optional<BankTrade> selectByMerchantRunningWaterNo(String merchantRunningWaterNo) {
        return Optional.of(merchantRunningWaterNo)
                .map(item -> lQrWrapper()
                        .eq(BankTrade::getMerchantRunningWaterNo, item)
                        .orderByDesc(BankTrade::getId)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public Optional<BankTrade> selectByRelationNo(String relationNo) {
        return Optional.of(relationNo)
                .map(item -> lQrWrapper()
                        .eq(BankTrade::getRelationNo, item)
                        .orderByDesc(BankTrade::getId)
                        .last("limit 1")
                )
                .map(super::getOne);    }
}
