package com.clx.performance.controller.temp;

import com.clx.performance.dto.gd.GdRouteDTO;
import com.clx.performance.esplus.model.TruckLatestPosESPlus;
import com.clx.performance.param.mq.trace.TruckTraceSyncMqParam;
import com.clx.performance.param.temp.DriverTraceAddParam;
import com.clx.performance.param.temp.TruckTraceAddParam;
import com.clx.performance.service.trace.TruckTraceMqHandlerService;
import com.clx.performance.service.trace.TruckTraceService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.utils.gd.GdService;
import com.clx.performance.vo.pc.trace.DriverTraceVO;
import com.clx.performance.vo.pc.trace.DriverTruckTraceVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/trace")
public class TempTraceController {

    @Autowired
    private TruckTraceService truckTraceService;

    @Autowired
    private GdService gdService;

    @Autowired
    private TruckTraceMqHandlerService truckTraceMqHandlerService;

    @Operation(summary = "test", description = "<br>By:艾庆国")
    @PostMapping("/test")
    public Result test(String truckNo, String beginTime, String endTime) {
        TruckTraceSyncMqParam mq = new TruckTraceSyncMqParam();
        mq.setTruckNo(truckNo);
        mq.setBeginTime(beginTime);
        mq.setEndTime(endTime);

        truckTraceMqHandlerService.truckTracSync(mq);

        return Result.ok();
    }
    @Operation(summary = "停留时长", description = "<br>By:艾庆国")
    @PostMapping("/getParkTime")
    public Result<Integer> getParkTime(String truckNo, Long userNo, String beginTime, String endTime) {

        int parkTime = truckTraceService.getParkTime(truckNo, userNo, LocalDateTimeUtils.parseTime(beginTime), LocalDateTimeUtils.parseTime(endTime));
        return Result.ok(parkTime);
    }

    @Operation(summary = "车辆轨迹同步", description = "<br>By:艾庆国")
    @PostMapping("/truckTraceSync")
    public Result truckTraceSync(@RequestBody TruckTraceAddParam param) {

        truckTraceService.truckTraceSave(param);

        return Result.ok();
    }

    @Operation(summary = "查询车辆轨迹", description = "<br>By:艾庆国")
    @PostMapping("/listTruckTraceByTime")
    public Result<List<DriverTruckTraceVO>> listTruckTraceByTime(String truckNo, String beginTime, String endTime) {

        return Result.ok(truckTraceService.listTruckTraceByTime(truckNo,beginTime,endTime));
    }

    @Operation(summary = "司机轨迹同步", description = "<br>By:艾庆国")
    @PostMapping("/driverTraceSync")
    public Result driverTraceSync(@RequestBody DriverTraceAddParam param) {

        truckTraceService.driverTraceSave(param);

        return Result.ok();
    }

    @Operation(summary = "查询司机轨迹", description = "<br>By:艾庆国")
    @PostMapping("/listDriverTraceByTime")
    public Result<List<DriverTraceVO>> listDriverTraceByTime(Long userNo, String beginTime, String endTime) {

        return Result.ok(truckTraceService.listDriverTraceByTime(userNo,beginTime,endTime));
    }


    @Operation(summary = "查询车辆5分钟内的最新位置", description = "<br>By:刘海泉")
    @PostMapping("/getTruckPosition")
    public Result<BigDecimal[]> getTruckPosition(String truckNo) {
        return Result.ok(truckTraceService.getCurrentTruckPosition(truckNo));
    }

    @Operation(summary = "线路规划", description = "<br>By:艾庆国")
    @PostMapping("/route")
    public Result<List<GdRouteDTO>> route(BigDecimal originLongitude, BigDecimal originLatitude,
                                                             BigDecimal destinationLongitude, BigDecimal destinationLatitude) {

        List<GdRouteDTO> gdRouteDTOS = gdService.getRoute(originLongitude, originLatitude, destinationLongitude, destinationLatitude);


        return Result.ok(gdRouteDTOS);
    }


    @Operation(summary = "批量保存车辆轨迹信息", description = "<br>By:刘海泉")
    @GetMapping("/saveTruckTrace")
    public Result<BigDecimal[]> saveTruckTrace(@Param("truckNo") @NotBlank(message = "车牌号不能为空") String truckNo,
            @Param("size")  @NotNull(message = "大小字段不能为空") Integer size,String gpsTime) {
        truckTraceService.saveTruckTrace(truckNo,size,gpsTime);
        return Result.ok();
    }


    @Operation(summary = "获取车辆最新位置信息", description = "<br>By:刘海泉")
    @GetMapping("/getTruckLatestPos")
    public Result<TruckLatestPosESPlus> getTruckLatestPos(@Param("truckNo")
    @NotBlank(message = "车牌号不能为空") String truckNo) {
        return Result.ok( truckTraceService.getTruckLatestPos(truckNo));
    }


    @Operation(summary = "获取车辆最新位置信息", description = "<br>By:姜武杰")
    @GetMapping("/calDistance")
    public Result<Integer> getTruckLatestPos(
            @RequestParam("l1") @NotNull(message = "当前经度不能为空") BigDecimal l1,
            @RequestParam("l2") @NotNull(message = "当前纬度不能为空") BigDecimal l2,
            @RequestParam("l3") @NotNull(message = "货源经度不能为空") BigDecimal l3,
            @RequestParam("l4") @NotNull(message = "货源纬度不能为空") BigDecimal l4
            ) {
        return Result.ok( gdService.getShortestRouteDistance(l1,l2,l3,l4));
    }


}
