package com.clx.performance.controller.feign;

import com.clx.performance.component.GoodsOrderTruckRecordComponent;
import com.clx.performance.service.OrderGoodsTruckBindService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

@RestController
@RequestMapping("/feign/orderGoodsDriverTruck")
@Validated
@Tag(name = "定向车辆Feign")
@AllArgsConstructor
public class TruckFeignController {

    private final OrderGoodsTruckBindService orderGoodsTruckService;

    private final GoodsOrderTruckRecordComponent goodsOrderTruckRecordComponent;

    @Deprecated
    @GetMapping({"/getTrucksByOrderGoodsNo"})
    Result<List<Integer>> getTrucksByOrderGoodsNo(@RequestParam("orderGoodsNo") @NotNull(message = "货单编号不可为空") String orderGoodsNo){
        return Result.ok(orderGoodsTruckService.getTrucksByOrderGoodsNo(orderGoodsNo));
    }

    @GetMapping({"/getPublicTruckList"})
    Result<Set<String>> getPublicTruckList(){
        return Result.ok(goodsOrderTruckRecordComponent.getPublicTruckList());
    }

    @GetMapping({"/getPrivateTruckList"})
    Result<List<String>> getPrivateTruckList(@RequestParam("orderGoodsNo") @NotBlank(message = "货单编号不可为空") String orderGoodsNo,
                                             @RequestParam("userNo") @NotNull(message = "用户编号不可为空") Long userNo){
        return Result.ok(goodsOrderTruckRecordComponent.getPrivateTruckList(orderGoodsNo,userNo));
    }

    @Operation(summary = "获取车队运营派发的公开单车车辆列表", description = "<br>By:刘海泉")
    @GetMapping({"/getFleetPublicTruckList"})
    Result<Set<String>> getFleetPublicTruckList(@RequestParam("orderGoodsNo") @NotBlank(message = "货单编号不可为空") String orderGoodsNo){
        return Result.ok(goodsOrderTruckRecordComponent.getFleetPublicTruckList(orderGoodsNo));
    }



}
