package com.clx.performance.constant;

/**
 * @Author: aiqingguo
 * @Description: 无车承运-mq
 * @Date: 2023-10-19 15:13:06
 * @Version: 1.0
 */
public class RabbitKeyBrokerConstants {

    private static final String PREFIX = "clx-performance.broker.";
    private static final String EXCHANGE = ".exchange";
    private static final String QUEUE = ".queue";
    private static final String QUEUE_ROUTING_KEY = ".routing.key";
    private static final String DELAY_QUEUE = ".delay.queue";
    private static final String DELAY_ROUTING_KEY = ".delay.routing.key";
    private static final String DEAD_QUEUE = ".dead.queue";
    private static final String DEAD_ROUTING_KEY = ".dead.routing.key";

    private RabbitKeyBrokerConstants() {
    }

    /**
     * 缺省交换机
     */
    public static final String DEFAULT_EXCHANGE = PREFIX +"default"+EXCHANGE;

    /**
     * 缺省延迟队列
     */
    public static final String DEFAULT_DELAY_QUEUE = PREFIX +"default"+DELAY_QUEUE;
    public static final String DEFAULT_DELAY_ROUTING_KEY = PREFIX +"default"+DELAY_ROUTING_KEY;
    public static final String DEFAULT_DEAD_QUEUE = PREFIX +"default"+DEAD_QUEUE;
    public static final String DEFAULT_DEAD_ROUTING_KEY = PREFIX +"default"+DEAD_ROUTING_KEY;

    /**
     * 运单同步
     */
    public static final String ORDER_CHILD_SYNC_QUEUE = PREFIX +"orderChild.sync"+QUEUE;
    public static final String ORDER_CHILD_SYNC_ROUTING_KEY = PREFIX +"orderChild.sync"+QUEUE_ROUTING_KEY;

    /**
     * 运单更新
     */
    public static final String ORDER_CHILD_UPDATE_QUEUE = PREFIX +"orderChild.update"+QUEUE;
    public static final String ORDER_CHILD_UPDATE_ROUTING_KEY = PREFIX +"orderChild.update"+QUEUE_ROUTING_KEY;

    /**
     * 司机支付
     */
    public static final String ORDER_CHILD_DRIVER_PAY_QUEUE = PREFIX +"orderChildDriver.pay"+QUEUE;
    public static final String ORDER_CHILD_DRIVER_PAY_ROUTING_KEY = PREFIX +"orderChildDriver.pay"+QUEUE_ROUTING_KEY;

}
