package com.clx.performance.vo.pc.integral;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 车辆积分规则
* @Date: 2023/11/06 14:12:53
* @Version: 1.0
*/

@Schema(description = "积分规则")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class AppIntegralRuleVO {

    @Schema(description = "运单完成积分规则")
    private OrderChildCompleteRule orderChildCompleteRule;
    @Schema(description = "货单奖励积分规则")
    private OrderAwardRule orderAwardRule;
    @Schema(description = "货单扣减积分规则")
    private OrderChildCancelRule orderChildCancelRule;
    @Schema(description = "运单超时扣减规则")
    private OrderChildTimeoutRule orderChildTimeoutRule;
    @Schema(description = "平台补偿积分规则")
    private PlatformCompensationRule platformCompensationRule;
    @Schema(description = "司机上报积分规则")
    private DriverReportRule driverReportRule;


    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderChildCompleteRule{
        @Schema(description = "当日完成第1笔运单积分x")
        @NotNull(message = "参数不能为空")
        private Integer integer1;
        @Schema(description = "当日完成第2笔运单积分x")
        @NotNull(message = "参数不能为空")
        private Integer integer2;
        @Schema(description = "当日完成第3笔运单积分x")
        @NotNull(message = "参数不能为空")
        private Integer integer3;
        @Schema(description = "当日完成第4笔运单积分x")
        @NotNull(message = "参数不能为空")
        private Integer integer4;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderAwardRule{
        @Schema(description = "完成流水单每单附加积分x")
        private Integer integerWater;
        @Schema(description = "当日流水单奖励次数上限x")
        private Integer countWaterLimit;
        @Schema(description = "完成支援单每单附加积分x")
        private Integer integerSupport;
        @Schema(description = "当日支援单奖励次数上限x")
        private Integer countSupportLimit;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderChildCancelRule {
        @Schema(description = "自行取消运单每单扣减积分x")
        @NotNull(message = "参数不能为空")
        private Integer integralCancel;
        @Schema(description = "自行取消流水单每单另扣积分x")
        private Integer integralWaterCancel;
        @Schema(description = "自行取消支援单每单另扣积分x")
        private Integer integralSupportCancel;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderChildTimeoutRule{
        @Schema(description = "超时未到达货源地扣积分x")
        @NotNull(message = "参数不能为空")
        private Integer integralSendAddressTimeout;
        @Schema(description = "超时未到达目的地扣积分x")
        @NotNull(message = "参数不能为空")
        private Integer integralReceiveAddressTimeout;
        @Schema(description = "接单超时扣积分x")
        private Integer integralTakeOrderTimeout;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class PlatformCompensationRule{
        @Schema(description = "平台取消运单补偿积分x")
        private Integer integralCancel;
        @Schema(description = "当日平台补偿积分上限x")
        private Integer integralCancelLimit;
        @Schema(description = "规定时间不能装车补偿x")
        private Integer integralLoad;
        @Schema(description = "规定时间不能卸车补偿x")
        private Integer integralUnload;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class DriverReportRule{
        @Schema(description = "提交基础信息每项积分x")
        private Integer integralTruck;
        @Schema(description = "油表上报积分x")
        private Integer integralRefuel;
//        @Schema(description = "上报交通拥堵积分x")
//        private Integer integralTraffic;
        @Schema(description = "上报货源地排队积分x")
        private Integer integralSendAddressWait;

        @Schema(description = "上报目的地需要排队积分x")
        private Integer integralReceiveAddressWait;


        @Schema(description = "上报煤炭质量问题积分x")
        private Integer integralQuality;
        @Schema(description = "上报拉运异常问题积分x")
        private Integer integralAbnormal;
        @Schema(description = "限制频繁上报奖励间隔x(小时)")
        private BigDecimal reportLimit;
        @Schema(description = "当日上报奖励积分上限x")
        private Integer integralLimit;
        @Schema(description = "上报货源地情况积分x")
        private Integer integralSendAddressInfo;
    }


    @Schema(description = "运单完成积分规则", example = "", hidden = true)
    private OrderChildCompleteRule orderChildCompleteRuleJson;
    @Schema(description = "货单奖励积分规则", example = "", hidden = true)
    private OrderAwardRule orderAwardRuleJson;
    @Schema(description = "货单扣减积分规则", example = "", hidden = true)
    private OrderChildCancelRule orderDiscountRuleJson;
    @Schema(description = "运单超时扣减规则", example = "", hidden = true)
    private OrderChildTimeoutRule orderChildTimeoutRuleJson;
    @Schema(description = "平台补偿积分规则", example = "", hidden = true)
    private PlatformCompensationRule platformCompensationRuleJson;

}