package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;


@Getter
@Setter
@NoArgsConstructor
public class OwnerAccountRunningWaterRecordVO {

    /**
     * id
     */
    @Schema(description="id")
    private Integer id;

    @Schema(description="流水号")
    private Long runningWaterNo;
    /**
     * 货主编码
     */
    @Schema(description="货主编码")
    private Long ownerUserNo;
    /**
     * 货主名称
     */
    @Schema(description="货主名称")
    private String ownerUserName;
    /**
     * 联系电话
     */
    @Schema(description="联系电话")
    private String mobile;
    /**
     * 账户类型
     */
    @Schema(description="账户类型")
    private Integer accountType;

    /**
     * 关联数据主键ID
     */
    @Schema(description="关联数据主键ID")
    private Integer relationId;
    /**
     * 流水类型
     */
    @Schema(description="流水类型 10：充值 20：冻结 30：解冻 40：提现冻结 50：提现成功 60：扣除 70：提现失败")
    private Integer runningWaterType;
    /**
     * 订单ID
     */
    @Schema(description="订单ID")
    private Integer orderId;
    /**
     * 订单编号
     */
    @Schema(description="订单编号")
    private String orderNo;
    /**
     * 运单ID
     */
    @Schema(description="运单ID")
    private Integer orderChildId;
    /**
     * 运单编号
     */
    @Schema(description="运单编号")
    private String orderChildNo;
    /**
     * 变动金额
     */
    @Schema(description="变动金额")
    @MoneyOutConvert
    private BigDecimal alterationBalance;
    /**
     * 冻结金额
     */
    @Schema(description="冻结金额")
    @MoneyOutConvert
    private BigDecimal frozenBalance;
    /**
     * 可用余额
     */
    @Schema(description="可用余额")
    @MoneyOutConvert
    private BigDecimal usableBalance;
    /**
     * 账户余额
     */
    @Schema(description="账户余额")
    @MoneyOutConvert
    private BigDecimal accountBalance;

    @Schema(description="扣除金额")
    @MoneyOutConvert
    private BigDecimal takeOutBalance;
    /**
     * 操作人
     */
    @Schema(description="操作人")
    private String createBy;
    /**
     * 操作时间
     */
    @Schema(description="操作时间")
    private String createTime;

}