package com.clx.performance.vo.pc;

import com.msl.common.convertor.field.Converted;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderGoodsEditVO {

    @Schema(description="订单编号")
    private String orderNo;
    @Schema(description="拉运结束时间")
    private String transportEndTime;
    @Schema(description="拉运吨数")
    private BigDecimal transportWeight;
    @Schema(description="有效运费")
    @MoneyOutConvert
    private BigDecimal validFreightPrice;
    @Schema(description="用车需求： 1平台车辆 2部分平台车辆 3自有车辆")
    private Integer truckDemand;
    @Schema(description="剩余拉运吨数")
    private String residueWeight;
    @Schema(description="自有承运吨数")
    private String ownCarryWeight;
    @Schema(description="自有承运剩余吨数")
    private String ownResidueCarryWeight;
    @Schema(description="平台承运吨数")
    private String platformCarryWeight;
    @Schema(description="平台剩余承运吨数")
    private String platformResidueCarryWeight;
    @Schema(description="向下浮动量（吨）")
    private String downFloatWeight;
    @Schema(description="向上浮动量（吨）")
    private String upFloatWeight;
    @Schema(description="是否暂停 0：否   1：是")
    private Integer stopFlag;
    @Schema(description="结算账期  1拉运完成结  2月结")
    private Integer settlementAccountPeriod;
    @Schema(description="1:可以全部编辑 0：不能全部编辑")
    private boolean editAllFlag;

    @Schema(description="货单数据")
    @Converted(isDynamic = false)
    private OrderGoodsVO orderGoodsVO;
}
