package com.clx.performance.param.pc;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class PageOwnerTopUpListParam extends PageParam {

    @Schema(description = "开始时间", example = "2020-01-01 10:10:10")
    private String beginTime;

    @Schema(description = "结束时间", example = "2020-01-01 10:10:10")
    private String endTime;

    @Schema(description = "充值账户类型 1：保证金 2：预付运费", example = "1")
    private Integer accountType;

    @Schema(description = "货主用户编码")
    private Long ownerUserNo;
}
