package com.clx.performance.param.pc;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class PageCarrierOrderListParam extends PageParam {

    @Schema(description = "订单编号")
    private String orderNo;

    @Schema(description = "联系人(货主)id")
    private Integer contactId;

    @Schema(description = "订单状态：2:报价已确认 3:平台已承接  7:挂单中 8:运输中 11:已挂单")
    private Integer orderStatus;

    @Schema(description = "开始时间", example = "2023-09-09 12:00:01", required = true)
    private String beginTime;

    @Schema(description = "结束时间", example = "2023-09-09 12:00:01", required = true)
    private String endTime;

    @Schema(description = "时间类型： 1创建时间 2拉运开始时间 3拉运结束时间 ")
    @NotNull(message = "时间类型不能为空")
    private Integer timeType;

    @Schema(description = "用车类型： 1平台车辆 2部分平台车辆 3自有车辆")
    private Integer truckDemand;

}
