package com.clx.performance.dao.impl.settle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.enums.settle.SettlementDriverEnum;
import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.mapper.settle.SettlementDriverDetailMapper;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverDetailParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 车主运单计费明细
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementDriverDetailDaoImpl extends BaseDaoImpl<SettlementDriverDetailMapper, SettlementDriverDetail, Integer> implements SettlementDriverDetailDao {
    @Override
    public boolean updateInvoiceTypeAndPrepayFreightFlag(SettlementDriverDetail item) {
        return update(lUdWrapper()
                .eq(SettlementDriverDetail::getId, item.getId())
                .set(SettlementDriverDetail::getInvoiceType, item.getInvoiceType())
                .set(SettlementDriverDetail::getPrepayFreight, item.getPrepayFreight())
                .set(SettlementDriverDetail::getPrepayFreightFlag, item.getPrepayFreightFlag())
                .set(SettlementDriverDetail::getLoanFlag, item.getLoanFlag())
                .set(SettlementDriverDetail::getLoanTypeFlag, item.getLoanTypeFlag())

                .set(SettlementDriverDetail::getInvoicingCompanyId, item.getInvoicingCompanyId())
                .set(SettlementDriverDetail::getInvoicingCompanyShorterName, item.getInvoicingCompanyShorterName())
                .set(SettlementDriverDetail::getInvoicingCompanyGroupCode, item.getInvoicingCompanyGroupCode())
        );
    }

    @Override
    public boolean updateSettlementNo(SettlementDriverDetail item) {
        return update(lUdWrapper()
                .eq(SettlementDriverDetail::getId, item.getId())
                .set(SettlementDriverDetail::getSettlementNo, item.getSettlementNo())
        );
    }

    @Override
    public Optional<SettlementDriverDetail> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(SettlementDriverDetail::getChildNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public IPage<SettlementDriverDetail> pageSettlementDriverDetail(PageCarrierSettlementDriverDetailParam param) {
        LambdaQueryWrapper<SettlementDriverDetail> query = new LambdaQueryWrapper<>();
        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(SettlementDriverDetail :: getChildNo,param.getChildNo());
        }
        if(StringUtils.isNotBlank(param.getOrderNo())){
            query.eq(SettlementDriverDetail :: getOrderNo,param.getOrderNo());
        }
        if(Objects.nonNull(param.getDriverUserNo())){
            query.eq(SettlementDriverDetail :: getDriverUserNo,param.getDriverUserNo());
        }
        if(StringUtils.isNotBlank(param.getDriverUserName())){
            query.like(SettlementDriverDetail :: getDriverName,param.getDriverUserName());
        }
        query.orderByDesc(SettlementDriverDetail :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public List<SettlementDriverDetail> listUnPay(LocalDateTime beginTime) {
        return baseMapper.listUnPay(beginTime);
    }

    @Override
    public List<SettlementDriverDetail> findByDriverSettlementIds(List<Integer> ids) {
        return baseMapper.findByDriverSettlementIds(ids);
    }

    @Override
    public void updateLoanFlagByChildNoList(List<String> childNoList) {
         update(lUdWrapper()
                .in(SettlementDriverDetail::getChildNo, childNoList)
                .set(SettlementDriverDetail::getLoanFlag, OwnerLoanRecordEnum.LoanFlag.RE_PAY.getCode())
        );
    }

    @Override
    public SettlementDriverDetail selectLoanFlag(String orderNo) {
        return baseMapper.selectOne(lQrWrapper().eq(SettlementDriverDetail::getOrderNo, orderNo)
                .eq(SettlementDriverDetail::getLoanFlag, OwnerLoanRecordEnum.LoanFlag.NO_LOAN.getCode())
                .eq(SettlementDriverDetail::getInvoiceType, SettlementOwnerEnum.InvoiceType.ONLINE.getCode())
                .eq(SettlementDriverDetail::getPrepayFreightFlag, SettlementDriverEnum.PrepayFreightFlag.NO_PAY.getCode())
                .last("limit 1")
        );
    }

    @Override
    public SettlementDriverDetail selectLoanTypeFlag(String orderNo) {
        return baseMapper.selectOne(lQrWrapper().eq(SettlementDriverDetail::getOrderNo, orderNo)
                .eq(SettlementDriverDetail::getLoanFlag, OwnerLoanRecordEnum.LoanFlag.LOAN.getCode())
                .eq(SettlementDriverDetail::getInvoiceType, SettlementOwnerEnum.InvoiceType.ONLINE.getCode())
                        .ne(SettlementDriverDetail::getLoanTypeFlag, OwnerLoanRecordEnum.LoanTypeFlag.FUND.getCode())
                .eq(SettlementDriverDetail::getPrepayFreightFlag, SettlementDriverEnum.PrepayFreightFlag.NO_PAY.getCode())
                .last("limit 1")
        );
    }

    @Override
    public List<SettlementDriverDetail> selectListByLoanFlag(Integer code) {
        return baseMapper.selectList(lQrWrapper().eq(SettlementDriverDetail::getLoanFlag, code));
    }

}
